// Dialog file for In-Game-Script-Editor v1.1

#define noColor        0,0,0,0
#define IGSE_FrameSize 0.0035

// Aspect ratio settings
#ifndef AR_modifX
	__EXEC(AR_CENTER=0; AR_modifX=0; AR_modifY=0; AR_modifX_2NDMON=0; version=0);
	igse_temp1 = __EVAL(if (localize "STR_USRACT_CHEAT_1" == "FWATCH") then {version=call loadFile ":info version"});
	igse_temp2 = __EVAL(if (version>=1.15) then {call preProcessFile "..\fwatch\data\getAspectRatio.sqf"});
#endif





// Base classes--------------------------------------------------
class igseTXT
{
	idc = -1
	type = 0
	style = 0
	text = ;
	colorBackground[] = {black, 0.8};
	colorText[] = {white85, 1};
	font = tahoma48
	sizeEx = 0.02
	lineSpacing = 1
};

class igseLISTBOX : igseTXT
{
	type = 5
	colorSelect[] = {OFP_gray, 1};
	rowHeight = 0.028
};
//---------------------------------------------------------------




//****************FILE MANAGER DIALOG****************************

class IGSE_FileManager
{
	idd = 0;
	movingEnable = 1;
	controls[] = {};
	controlsBackground[]=
	{
		Frame, FrameBackground, 
		PathInfo1, PathInfo2, FileInfo1, FileInfo2, FileInfo3, FileInfo4, FileInfo5, ClipMSG,
		ListBoxBackground, ListBox, VersionMSG, Clock,
		//ImagePreviewBackground,
		ImagePreviewInfo1,
		ImagePreviewInfo2,
		ImagePreviewInfo3,
		ImagePreview1,
		ImagePreview2, ImagePreview_2,
		ImagePreview4, ImagePreview_4,
		ImagePreview8, ImagePreview_8
	};
	
// gray field around listbox
__EXEC(IGSE_FM_BackW = 0.6)
__EXEC(IGSE_FM_BackX = 1 - IGSE_FM_BackW)
__EXEC(IGSE_FM_BackX = IGSE_FM_BackX / 2)
__EXEC(IGSE_FM_BackX = IGSE_FM_BackX + IGSE_FM_OFF_X)
__EXEC(IGSE_FM_BackH = IGSE_FM_HEIGHT)
__EXEC(IGSE_FM_BackY = 1 - IGSE_FM_BackH)
__EXEC(IGSE_FM_BackY = IGSE_FM_BackY / 2 + IGSE_FM_OFF_Y)

// list box properties
__EXEC(IGSE_FM_BoxSpaceW = IGSE_FM_MARGIN)
__EXEC(IGSE_FM_BoxSpaceH = IGSE_FM_MARGIN*1.33)

__EXEC(IGSE_FM_BoxW = IGSE_FM_BackW - IGSE_FM_BoxSpaceW*2)
__EXEC(IGSE_FM_BoxH = IGSE_FM_BackH - IGSE_FM_BoxSpaceH - IGSE_FM_HEADER_H)
__EXEC(IGSE_FM_BoxX = IGSE_FM_BackX + IGSE_FM_BoxSpaceW)
__EXEC(IGSE_FM_BoxY = IGSE_FM_BackY + IGSE_FM_BackH - IGSE_FM_BoxH - IGSE_FM_BoxSpaceH)

	class Frame : igseTXT
	{
		idc = 1665003
		style = 80
		x = __EVAL(IGSE_FM_BackX - 0.0055)
		y = __EVAL(IGSE_FM_BackY - 0.008)
		w = __EVAL(IGSE_FM_BackW + 0.011)
		h = __EVAL(IGSE_FM_BackH + 0.015)
		colorBackground[] = {white, 1};
	};

	class FrameBackground : igseTXT
	{
		x = __EVAL(IGSE_FM_BackX)
		y = __EVAL(IGSE_FM_BackY)
		w = __EVAL(IGSE_FM_BackW)
		h = __EVAL(IGSE_FM_BackH)
		colorBackground[] = {windowsgray, 0.8};
	};
	
	// Unused
	class Title : igseTXT
	{
		x = __EVAL(IGSE_FM_BoxX + 0.035)
		y = __EVAL(IGSE_FM_BoxY - 0.08)
		w = __EVAL(IGSE_FM_BoxW)
		h = 0.06
		sizeEx = 0.05
		font = garamond
		colorText[] = {black, 1};
		colorBackground[] = {noColor};
		text = "Select a file to open:";
	};
	
	class PathInfo1 : igseTXT
	{
		idc = 10
		style = 0;
		x = __EVAL(IGSE_FM_BoxX)
		__EXEC(IGSE_PATHINFO_Y = IGSE_FM_BoxY - 0.095)
		y = __EVAL(IGSE_PATHINFO_Y)
		w = __EVAL(IGSE_FM_BoxW)
		#define IGSE_PATHINFO_SIZE 0.045
		h = IGSE_PATHINFO_SIZE
		sizeEx = IGSE_PATHINFO_SIZE - 0.005
		colorText[] = {white, 1};
		colorBackground[] = {red, 0};
		font = garamond
	};
	
	class PathInfo2 : PathInfo1
	{
		idc = 11
		y = __EVAL(IGSE_PATHINFO_Y + IGSE_PATHINFO_SIZE)
		sizeEx = IGSE_PATHINFO_SIZE - 0.015
	};
	
	class FileInfo1 : PathInfo1
	{
		idc = 12
		style = 0 + 256
		__EXEC(IGSE_FILEINFO_Y = IGSE_PATHINFO_Y + 0.005)
		y = __EVAL(IGSE_FILEINFO_Y)
		#define IGSE_FILEINFO_SIZE 0.025
		h = IGSE_FILEINFO_SIZE
		sizeEx = IGSE_FILEINFO_SIZE - 0.005
		font = tahoma48
		colorText[] = {white, 1};
	};
	
	class FileInfo2 : FileInfo1
	{
		idc = 13
		y = __EVAL(IGSE_FILEINFO_Y + IGSE_FILEINFO_SIZE)
	};
	
	class FileInfo3 : FileInfo2
	{
		idc = 14
		y = __EVAL(IGSE_FILEINFO_Y + IGSE_FILEINFO_SIZE*2.1)
		colorText[] = {lightgoldyell, 1};
	};
	
	class FileInfo4 : FileInfo3
	{
		idc = 15
		x = __EVAL(IGSE_FM_BoxX + 0.1)
	};
	
	class FileInfo5 : FileInfo3
	{
		idc = 16
		style = 1 + 256
	};
	
	class ClipMSG : FileInfo5
	{
		idc = 17
		style = 1 + 256
		y = __EVAL(IGSE_FILEINFO_Y)
		colorText[] = {red, 1};
	};
	
	class ListBoxBackground : igseTXT
	{
		x = __EVAL(IGSE_FM_BoxX)
		y = __EVAL(IGSE_FM_BoxY)
		w = __EVAL(IGSE_FM_BoxW)
		h = __EVAL(IGSE_FM_BoxH)
		colorBackground[] = {IGSE_FM_backColor, 1};
	};
	
	class ListBox : igseLISTBOX
	{
		idc = 0
		x = __EVAL(IGSE_FM_BoxX)
		y = __EVAL(IGSE_FM_BoxY)
		w = __EVAL(IGSE_FM_BoxW)
		h = __EVAL(IGSE_FM_BoxH)
		font = IGSE_FM_font
		rowHeight = IGSE_FM_rowSize
		sizeEx = IGSE_FM_rowFontSize
		colorText[]   = {IGSE_FM_fontColor, 1};	
		colorSelect[] = {IGSE_FM_fontSelCol, 1};
	};

	class VersionMSG : igseTXT
	{
		idc = 1000
		style = 1 + 256
		x = 0
		y = 0.92
		w = 1
		h = 0.04
		sizeEx = 0.035
		colorBackground[] = {noColor};
		colorText[] = {red, 1};
	};
	
	class Clock : igseTXT
	{
		idc = 1001
		style = 1 + 256
		x = 0
		y = 0.96
		w = 1
		h = 0.04
		sizeEx = 0.035
		colorBackground[] = {noColor};
		colorText[] = {white85, 1};
	};
	
	__EXEC(IGSE_IMG_PREVIEW_SIZE = IGSE_FM_IP_SIZE)
	__EXEC(IGSE_IMG_PREVIEW_X = IGSE_FM_BoxX + IGSE_FM_BoxW)
	__EXEC(IGSE_IMG_PREVIEW_Y = IGSE_FM_BoxY + IGSE_FM_BoxH - IGSE_IMG_PREVIEW_SIZE)

	#ifdef IGSE_FM_IP_OFF_X
		__EXEC(IGSE_IMG_PREVIEW_X = IGSE_IMG_PREVIEW_X + IGSE_FM_IP_OFF_X)
	#endif
	
	#ifdef IGSE_FM_IP_OFF_Y
		__EXEC(IGSE_IMG_PREVIEW_Y = IGSE_IMG_PREVIEW_Y + IGSE_FM_IP_OFF_Y)
	#endif
	
	#ifdef IGSE_FM_IP_X
		__EXEC(IGSE_IMG_PREVIEW_X = IGSE_FM_IP_X)
	#endif
	
	#ifdef IGSE_FM_IP_Y
		__EXEC(IGSE_IMG_PREVIEW_Y = IGSE_FM_IP_Y)
	#endif
	
	class ImagePreview1 : igseTXT
	{
		idc = 61
		style = 48; 
		colorText[] = {white,1};
		x = __EVAL(IGSE_IMG_PREVIEW_X)
		y = __EVAL(IGSE_IMG_PREVIEW_Y)
		w = __EVAL(IGSE_IMG_PREVIEW_SIZE)
		h = __EVAL(IGSE_IMG_PREVIEW_SIZE)
	}
	class ImagePreviewBackground : ImagePreview1 {idc=70;style=0;colorBackground[]={red,1};}
	
	class ImagePreview2 : ImagePreview1 {idc=62; h=__EVAL(IGSE_IMG_PREVIEW_SIZE/2*1.33);}
	class ImagePreview4 : ImagePreview1 {idc=64; h=__EVAL(IGSE_IMG_PREVIEW_SIZE/4*1.33);}
	class ImagePreview8 : ImagePreview1 {idc=68; h=__EVAL(IGSE_IMG_PREVIEW_SIZE/8*1.33);}
	
	class ImagePreview_2 : ImagePreview1 {idc=58; w=__EVAL(IGSE_IMG_PREVIEW_SIZE/2);}
	class ImagePreview_4 : ImagePreview1 {idc=56; w=__EVAL(IGSE_IMG_PREVIEW_SIZE/4);}
	class ImagePreview_8 : ImagePreview1 {idc=52; w=__EVAL(IGSE_IMG_PREVIEW_SIZE/8);}
	
	__EXEC(IGSE_IMG_PREVIEW_INFO_H = IGSE_IMG_PREVIEW_SIZE / 10)
	
	class ImagePreviewInfo1 : igseTXT {
		idc = 70
		style = 256
		x = __EVAL(IGSE_IMG_PREVIEW_X)
		y = __EVAL(IGSE_IMG_PREVIEW_Y - IGSE_IMG_PREVIEW_INFO_H)
		w = __EVAL(IGSE_IMG_PREVIEW_SIZE)
		h = __EVAL(IGSE_IMG_PREVIEW_INFO_H)
		sizeEx = __EVAL(IGSE_IMG_PREVIEW_INFO_H)
		colorText[] = {lightgoldyell,1};
		colorBackground[] = {black,0};
		font = courier
	}
	class ImagePreviewInfo2 : ImagePreviewInfo1 {
		idc = 71
		style = 16 + 256
		y = __EVAL(IGSE_IMG_PREVIEW_Y)
		h = __EVAL(IGSE_IMG_PREVIEW_SIZE)
		colorText[] = {red,1};
	}
	class ImagePreviewInfo3 : ImagePreviewInfo1 {
		idc = 72
		y = __EVAL(IGSE_IMG_PREVIEW_Y + IGSE_IMG_PREVIEW_SIZE)
	}
};

//***************************************************************








//****************FILE INPUT DIALOG *****************************

class IGSE_FileInput : IGSE_FileManager
{
	idd = 0;
	movingEnable = 1;
	controls[] = {};
	controlsBackground[]=
	{
		Hidden, 
		File_Frame, 
		File_FrameBackground, 
		File_Title, 
		File_InputBackground, 
		File_Input, 
		VersionMSG, 
		Clock, 
		File_Icon
	};
	
// File create / rename box
#define FileBoxW       0.4
#define FileBoxH       0.05
#define FileBoxIconW   FileBoxH / 1.34
#define FileBoxIconH   FileBoxH
#define FileBoxSpaceW  0.02
#define FileBoxSpaceH  0.025
#define FileBoxSpaceH2 0.01
#define FileBoxFrameW  FileBoxW + FileBoxSpaceW*2
#define FileBoxFrameH  FileBoxH*2 + FileBoxSpaceH + FileBoxSpaceH2*2
#define FileBoxFrameX  (1 - (FileBoxFrameW)) / 2
#define FileBoxFrameY  (1 - (FileBoxFrameH)) / 2
#define FileBoxTextX   FileBoxFrameX + 0.035
#define FileBoxTextY   FileBoxFrameY + FileBoxSpaceH2
#define FileBoxX       FileBoxFrameX + FileBoxSpaceW
#define FileBoxY       FileBoxFrameY + FileBoxH + FileBoxSpaceH2*2


	class Hidden : igseTXT {style=0; x=0; y=-0.01; w=0.01; h=0.01; idc=1665004;};

	class File_Frame : Frame
	{
		idc = 10
		x = FileBoxFrameX - 0.0055
		y = FileBoxFrameY - 0.008
		w = FileBoxFrameW + 0.011
		h = FileBoxFrameH + 0.015
	};
	
	class File_FrameBackground : FrameBackground
	{
		idc = 11
		x = FileBoxFrameX
		y = FileBoxFrameY
		w = FileBoxFrameW
		h = FileBoxFrameH
	};
		
	class File_Icon : Title
	{
		idc = 15
		style=48; colorText[]={white,1};
		x = FileBoxX - 0.007
		y = FileBoxTextY
		w = FileBoxIconW
		h = FileBoxIconH
		sizeEx = FileBoxH - 0.025
		font = tahoma36
		text = "..\In-Game-Script-Editor\paa\folder_closed.paa"
		//colorBackground[] = {red, 0.4};
	};

	class File_Title : Title
	{
		idc = 12
		x = FileBoxTextX + FileBoxIconH/2.5
		y = FileBoxTextY
		w = FileBoxW
		h = FileBoxH
		sizeEx = FileBoxH - 0.025
		font = tahoma36
		text = "Do something with the file here"
		//colorBackground[] = {red, 0.4};
	};
	
	class File_Input : igseTXT
	{
		idc = 13
		type = 2
		x = FileBoxX
		y = FileBoxY
		w = FileBoxW
		h = FileBoxH
		font = tahoma36
		sizeEx = FileBoxH - 0.025;
		autocomplete = general;
		colorText[] = {IGSE_FM_fontColor, 1};
		colorSelection[] = {red, 0.5};
	};
	
	class File_InputBackground : File_Input
	{
		idc = 14
		type = 0;
		colorBackground[] = {IGSE_FM_backColor, 1};
	};
	
	class VersionMSG : igseTXT
	{
		idc = 1000
		style = 1 + 256
		x = 0
		y = 0.92
		w = 1
		h = 0.04
		sizeEx = 0.035
		colorBackground[] = {noColor};
		colorText[] = {red, 1};
	};
	
	class Clock : igseTXT
	{
		idc = 1001
		style = 1 + 256
		x = 0
		y = 0.96
		w = 1
		h = 0.04
		sizeEx = 0.035
		colorBackground[] = {noColor};
		colorText[] = {white85, 1};
	};
};







//****************TEXT EDITOR DIALOG*****************************

class IGSE_TextEditor
{
	idd = 25;
	movingEnable = 1;
	controls[] = {};
	controlsBackground[]=
	{
		Lower_Frame, Lower_Background, Input,
		Main_Frame, Main_Background, Main_ListBox,
		Upper_Frame, Upper_Background, Upper_LineCounter,
		Upper_CharCounter, Upper_Status, Upper_StatusFind, ErrorMsg1, ErrorMsg2,
		VersionMSG, Clock,MarkedText
	};
	
	//------------DIALOG HEIGHT CALCULATION------------------
	// so it can be set on the center of the screen	
	__EXEC(IGSE_UpBoxH   = IGSE_UPPER_BOX_HEIGHT)
	__EXEC(IGSE_LowBoxH  = IGSE_input_fontsize + IGSE_LOWER_BOX_OFFSET)
	__EXEC(IGSE_MainBoxH = IGSE_HEIGHT - IGSE_UpBoxH - IGSE_LowBoxH - IGSE_SPC_BETWEEN_FRAMES1 - IGSE_SPC_BETWEEN_FRAMES2)
	
// Set Y pos to custom if user defined such
#ifndef IGSE_customY
	__EXEC(IGSE_UpBoxY = 1 - IGSE_HEIGHT)
	__EXEC(IGSE_UpBoxY = IGSE_UpBoxY / 2)
#else
	__EXEC(IGSE_UpBoxY = IGSE_customY)
#endif
	
	
	//------------UPPER BOX----------------------------------
	// elements are built upon the upper box
	__EXEC(IGSE_UpBoxW = IGSE_WIDTH)
	__EXEC(IGSE_UpBoxX = 1 - IGSE_UpBoxW)
	__EXEC(IGSE_UpBoxX = IGSE_UpBoxX / 2)
	
	// transparency setting
	#define IGSE_UpBoxT1 IGSE_Transp
	#define IGSE_UpBoxT2 IGSE_Transp / 4
	
	
	class Upper_Frame : igseTXT
	{
		idc = 1665005
		style = 80
		x = __EVAL(IGSE_UpBoxX - 0.005)
		y = __EVAL(IGSE_UpBoxY - 0.007)
		w = __EVAL(IGSE_UpBoxW + 0.011)
		h = __EVAL(IGSE_UpBoxH + 0.015)
		colorBackground[] = {white, IGSE_UpBoxT1};

	};
	
	class Upper_Background : igseTXT
	{
		idc = 1
		x = __EVAL(IGSE_UpBoxX)
		y = __EVAL(IGSE_UpBoxY)
		w = __EVAL(IGSE_UpBoxW)
		h = __EVAL(IGSE_UpBoxH)
		sizeEx = 0.035;
		colorText[] = {lightblue2, 1};
		colorBackground[] = {OFP_gray, IGSE_UpBoxT2};
	};
	
	class Upper_LineCounter : igseTXT
	{
		idc = 2
		x = __EVAL(IGSE_UpBoxX + (IGSE_UpBoxW / 2))
		y = __EVAL(IGSE_UpBoxY + (IGSE_UpBoxH - 0.02))
		w = 0.13
		h = 0.02
		font = courier
		colorText[] = {slategray1, 1};
		colorBackground[] = {noColor};
	};
	
	class Upper_CharCounter : Upper_LineCounter
	{
		idc = 3
		x = __EVAL(IGSE_UpBoxX + (IGSE_UpBoxW / 1.55))
	};
	
	class Upper_Status : Upper_LineCounter
	{
		idc = 4
		style = 1
		x = __EVAL(IGSE_UpBoxX)
		w = __EVAL(IGSE_UpBoxW)
		//x = IGSE_UpBoxX + IGSE_UpBoxW - 0.235
		//w = 0.235
		//colorBackground[] = {red, 0.5};
	};
	
	class Upper_StatusFind : Upper_Status
	{
		idc = 5
		//x = IGSE_UpBoxX + IGSE_UpBoxW - 0.45
		//w = 0.45
		x = __EVAL(IGSE_UpBoxX)
		w = __EVAL(IGSE_UpBoxW)
		y = __EVAL(IGSE_UpBoxY + 0.002)
	};
	
	class ErrorMsg1 : Upper_LineCounter
	{
		idc = 6
		style = 0
		colorText[] = {red, 1};
		colorBackground[] = {black, 0.5};
		x = __EVAL(IGSE_UpBoxX)
		y = __EVAL(IGSE_UpBoxY)
		w = __EVAL(IGSE_UpBoxW)
		h = __EVAL(IGSE_UpBoxH / 2)
	}
	
	class ErrorMsg2 : ErrorMsg1
	{
		idc = 7
		y = __EVAL(IGSE_UpBoxY + IGSE_UpBoxH / 2)
	}


	//------------MAIN BOX--------------------------------------
	__EXEC(IGSE_MainBoxX = IGSE_UpBoxX)
	__EXEC(IGSE_MainBoxY = IGSE_UpBoxY + IGSE_UpBoxH + IGSE_SPC_BETWEEN_FRAMES1)
	__EXEC(IGSE_MainBoxW = IGSE_UpBoxW - 0.001)

	#define IGSE_MainBoxT1 IGSE_Transp
	#define IGSE_MainBoxT2 (IGSE_Transp / 2)


	class Main_Frame : Upper_Frame
	{
		x = __EVAL(IGSE_MainBoxX - 0.005)
		y = __EVAL(IGSE_MainBoxY - 0.007)
		w = __EVAL(IGSE_MainBoxW + 0.012)
		h = __EVAL(IGSE_MainBoxH + 0.0167)
		colorBackground[] = {white, IGSE_MainBoxT1};
	};	

	class Main_Background : igseTXT
	{
		x = __EVAL(IGSE_MainBoxX)
		y = __EVAL(IGSE_MainBoxY)
		w = __EVAL(IGSE_MainBoxW)
		h = __EVAL(IGSE_MainBoxH)
		colorBackground[] = {IGSE_LayerColor};
	};

	class Main_ListBox : igseLISTBOX
	{
		idc = 10
		x = __EVAL(IGSE_MainBoxX)
		y = __EVAL(IGSE_MainBoxY)
		w = __EVAL(IGSE_MainBoxW)
		h = __EVAL(IGSE_MainBoxH)
		font = IGSE_font
		sizeEx = IGSE_fontSize
		rowHeight = IGSE_rowSize
		colorText[]   = {IGSE_fontColor};
		colorSelect[] = {IGSE_fontSelCol};
	};



	//------------LOWER BOX-------------------------------------
	__EXEC(IGSE_LowBoxX = IGSE_UpBoxX)
	__EXEC(IGSE_LowBoxY = IGSE_MainBoxY + IGSE_MainBoxH + IGSE_SPC_BETWEEN_FRAMES2)
	__EXEC(IGSE_LowBoxW = IGSE_UpBoxW - 0.001)


	class Lower_Frame : Upper_Frame
	{
		x = __EVAL(IGSE_LowBoxX - 0.005)
		y = __EVAL(IGSE_LowBoxY - 0.007)
		w = __EVAL(IGSE_LowBoxW + 0.012)
		h = __EVAL(IGSE_LowBoxH + 0.0167)
	};

	class Lower_Background : Main_Background
	{
		idc = 101
		x = __EVAL(IGSE_LowBoxX)
		y = __EVAL(IGSE_LowBoxY)
		w = __EVAL(IGSE_LowBoxW)
		h = __EVAL(IGSE_LowBoxH)
		font = courier
		colorText[] = {IGSE_input_fontcolor};
		colorBackground[] = {IGSE_input_color, IGSE_MainBoxT2};
	};

	class Input : igseTXT
	{
		idc = 100
		type = 2
		x = __EVAL(IGSE_LowBoxX)
		y = __EVAL(IGSE_LowBoxY)
		w = __EVAL(IGSE_LowBoxW)
		h = __EVAL(IGSE_LowBoxH)
		font = IGSE_font
		sizeEx = IGSE_input_fontsize;
		autocomplete = #IGSE_autocomplete
		colorText[] = {IGSE_input_fontcolor};
		colorSelection[] = {red, 0.5};
	};	


	class VersionMSG : igseTXT
	{
		idc = 1000
		style = 1 + 256
		x = 0
		y = 0.92
		w = 1
		h = 0.04
		sizeEx = 0.035
		colorBackground[] = {noColor};
		colorText[] = {red, 1};
	};
	
	class Clock : VersionMSG
	{
		idc = 1001
		y = 0.96
		colorText[] = {white85, 1};
	};
	
	class MarkedText : Clock
	{
		idc = 1002
		sizeEx = 0.02;
		style = 0 + 256;
		x = __EVAL(IGSE_LowBoxX - 0.002)
		y = __EVAL(IGSE_LowBoxY + IGSE_LowBoxH + 0.008)
		w = __EVAL(IGSE_LowBoxW)
		text = ""
	};
};







//****************SEARCH DIALOG**********************************

class IGSE_TextSearch : IGSE_FileInput
{
	idd = 0;
	movingEnable = 1;
	controls[] = {};
	controlsBackground[]=
	{
		Hidden, File_Frame, File_FrameBackground, 
		
		File_Title, File_InputBackground, File_Input, 
		Replace_Title, Replace_InputBackground, Replace_Input,
		
		File_Text1, File_Text2, File_Text3,
		File_Text1_t, File_Text2_t, File_Text3_t,
		
		VersionMSG, Clock,
	};
	
// File create / rename box
#define IGSE_FINDBOX_W       0.4
#define IGSE_FINDBOX_H       0.05
#define IGSE_FINDBOX_SPACEW  0.02
#define IGSE_FINDBOX_SPACEH  0.025
#define IGSE_FINDBOX_SPACEH2 0.01
#define IGSE_FINDBOX_SPACEH3 0.00
#define IGSE_FINDBOX_TEXTX   IGSE_FINDBOX_FRAMEX + 0.035
#define IGSE_FINDBOX_TEXTY   IGSE_FINDBOX_FRAMEY + IGSE_FINDBOX_SPACEH2
#define IGSE_FINDBOX_BOXX    IGSE_FINDBOX_FRAMEX + IGSE_FINDBOX_SPACEW
#define IGSE_FINDBOX_BOXY    IGSE_FINDBOX_FRAMEY + IGSE_FINDBOX_H + IGSE_FINDBOX_SPACEH2*2

#define IGSE_FINDBOX_TEXT2Y IGSE_FINDBOX_BOXY + IGSE_FINDBOX_H + IGSE_FINDBOX_SPACEH2
#define IGSE_FINDBOX_BOX2Y  IGSE_FINDBOX_TEXT2Y + IGSE_FINDBOX_H

#define IGSE_FINDBOX_FRAMEW IGSE_FINDBOX_W + IGSE_FINDBOX_SPACEW*2
#define IGSE_FINDBOX_FRAMEH IGSE_FINDBOX_H*7 + IGSE_FINDBOX_SPACEH + IGSE_FINDBOX_SPACEH2*2
#define IGSE_FINDBOX_FRAMEX (1 - (IGSE_FINDBOX_FRAMEW)) / 2
#define IGSE_FINDBOX_FRAMEY (1 - (IGSE_FINDBOX_FRAMEH)) / 2


	class Hidden : igseTXT {style=0; x=0; y=-0.01; w=0.01; h=0.01; idc=1665006;};

	class File_Frame : Frame
	{
		idc = 10
		x = IGSE_FINDBOX_FRAMEX - 0.0055
		y = IGSE_FINDBOX_FRAMEY - 0.008
		w = IGSE_FINDBOX_FRAMEW + 0.011
		h = IGSE_FINDBOX_FRAMEH + 0.015
	};
	
	class File_FrameBackground : FrameBackground
	{
		idc = 11
		x = IGSE_FINDBOX_FRAMEX
		y = IGSE_FINDBOX_FRAMEY
		w = IGSE_FINDBOX_FRAMEW
		h = IGSE_FINDBOX_FRAMEH
	};
		
	class File_Title : Title
	{
		idc = 12
		x = IGSE_FINDBOX_TEXTX
		y = IGSE_FINDBOX_TEXTY
		w = IGSE_FINDBOX_W
		h = IGSE_FINDBOX_H
		sizeEx = IGSE_FINDBOX_H - 0.025
		font = tahoma36
		text = "Find what:"
		//colorBackground[] = {red, 0.4};
	};

	class File_Text1 : File_Title
	{
		idc = 20
		y = IGSE_FINDBOX_BOX2Y + IGSE_FINDBOX_H + IGSE_FINDBOX_SPACEH2
		text = "Ctrl + D to match whole word only"
		colorText[]={OFP_black, 1};
	};
	
	class File_Text2 : File_Text1
	{
		idc = 22
		y = IGSE_FINDBOX_BOX2Y + IGSE_FINDBOX_H*2 + IGSE_FINDBOX_SPACEH2
		text = "Ctrl + C to match case"
	};
	
	class File_Text3 : File_Text1
	{
		idc = 24
		y = IGSE_FINDBOX_BOX2Y + IGSE_FINDBOX_H*3 + IGSE_FINDBOX_SPACEH2
		text = "Ctrl + R to replace all"
	};
	
	class File_Text1_t : File_Text1 {idc=21; colorText[]={OFP_black,0.3};};
	class File_Text2_t : File_Text2 {idc=23; colorText[]={OFP_black,0.3};};
	class File_Text3_t : File_Text3 {idc=25; colorText[]={OFP_black,0.3};};
	
	class File_Input : igseTXT
	{
		idc = 13
		type = 2
		x = IGSE_FINDBOX_BOXX
		y = IGSE_FINDBOX_BOXY
		w = IGSE_FINDBOX_W
		h = IGSE_FINDBOX_H
		font = tahoma36
		sizeEx = IGSE_FINDBOX_H - 0.025;
		autocomplete = general;
		colorText[] = {IGSE_FM_fontColor, 1};
		colorSelection[] = {red, 0.5};
	};
	
	class File_InputBackground : File_Input
	{
		idc = 14
		type = 0;
		colorBackground[] = {IGSE_FM_backColor, 1};
	};
	
	class Replace_Title : File_Title
	{
		idc = 15
		y = IGSE_FINDBOX_TEXT2Y
		text = "Replace with:"
		//colorBackground[] = {red, 0.4};
	};
	
	class Replace_Input : File_Input
	{
		idc = 16
		y = IGSE_FINDBOX_BOX2Y
	};
	
	class Replace_InputBackground : File_InputBackground
	{
		idc = 17
		y = IGSE_FINDBOX_BOX2Y
	};
	
	class VersionMSG : igseTXT
	{
		idc = 1000
		style = 1 + 256
		x = 0
		y = 0.92
		w = 1
		h = 0.04
		sizeEx = 0.035
		colorBackground[] = {noColor};
		colorText[] = {red, 1};
	};
	
	class Clock : igseTXT
	{
		idc = 1001
		style = 1 + 256
		x = 0
		y = 0.96
		w = 1
		h = 0.04
		sizeEx = 0.035
		colorBackground[] = {noColor};
		colorText[] = {white85, 1};
	};
};







//****************INFO DIALOG************************************

class IGSE_Help
{
	idd = 0;
	movingEnable = 1;
	controls[] = {};
	controlsBackground[]=
	{
		Background, 
		Frame, 
		DummyTextArea, 
		Text1, 
		Text2, 
		VersionMSG, 
		Clock,
	};
	
	__EXEC(IGSE_HELP_LINE_NUMBER = 41)
	
	__EXEC(IGSE_HELP_Y   = 0 - AR_modifY)
	__EXEC(IGSE_HELP_W1  = 0.36)
	__EXEC(IGSE_HELP_W2  = 0.36)
	__EXEC(IGSE_HELP_SPC = 0.01)
	__EXEC(IGSE_HELP_W   = IGSE_HELP_W1 + IGSE_HELP_SPC + IGSE_HELP_W2)
	__EXEC(IGSE_HELP_H   = 1 + AR_modifY)
	__EXEC(IGSE_HELP_X   = 1 - IGSE_HELP_W)
	__EXEC(IGSE_HELP_X   = IGSE_HELP_X / 2)

	class Background : igseTXT
	{
		idc = 1665007
		colorBackground[]={black, 0.75};
		x = __EVAL(IGSE_HELP_X)
		y = __EVAL(IGSE_HELP_Y)
		w = __EVAL(IGSE_HELP_W)
		h = __EVAL(IGSE_HELP_H)
	};
	
	class Frame : Background
	{
		idc = 2
		style = 64;
		colorText[] = {white, 1};
		text = "Controls"
		font = courier
		sizeEx = 0.02
	};
	
	class DummyTextArea : igseTXT
	{
		style = 16;
		x = -2
		y = -2
		w = 0.1
		h = 0.1
	};
	
	class Text1 : igseTXT
	{
		__EXEC(IGSE_HELP_TXT_Y = IGSE_HELP_Y + 0.02)
		__EXEC(IGSE_HELP_TXT_H = IGSE_HELP_H - IGSE_HELP_TXT_Y);
		
		idc = 0
		style = 1 + 16 + 256;
		x = __EVAL(IGSE_HELP_X)
		y = __EVAL(IGSE_HELP_TXT_Y)
		w = __EVAL(IGSE_HELP_W1)
		h = __EVAL(IGSE_HELP_TXT_H)
		sizeEx = __EVAL(IGSE_HELP_TXT_H / IGSE_HELP_LINE_NUMBER)
		lineSpacing = 1.025
		colorText[]={lightgoldyell, 1};
		colorBackground[] = {red, 0};
	};
	
	class Text2 : Text1
	{
		idc = 1
		style = 0 + 16 + 256
		x = __EVAL(IGSE_HELP_X + IGSE_HELP_W1 + IGSE_HELP_SPC);
		w = __EVAL(IGSE_HELP_W2);
		colorText[]={white85, 1};
	};

	
	class VersionMSG : igseTXT
	{
		idc = 1000
		style = 1 + 256
		x = 0
		y = 0.92
		w = 1
		h = 0.04
		sizeEx = 0.035
		colorBackground[] = {noColor};
		colorText[] = {red, 1};
	};
	
	class Clock : igseTXT
	{
		idc = 1001
		style = 1 + 256
		x = 0
		y = 0.96
		w = 1
		h = 0.04
		sizeEx = 0.035
		colorBackground[] = {noColor};
		colorText[] = {white85, 1};
	};	
};







//****************RECENT FILES DIALOG****************************

class IGSE_RecentFiles
{
	idd = 0;
	movingEnable = 1;
	controls[] = {};
	controlsBackground[]={RecentBackground, RecentList, VersionMSG, Clock};
	
	__EXEC(IGSE_RECENT_ROWS = 20)
	__EXEC(IGSE_RECENT_ROW_H = IGSE_MainBoxH / IGSE_RECENT_ROWS)
	
	class RecentBackground : igseTXT {
		idc = 1665008
		x = __EVAL(IGSE_MainBoxX)
		y = __EVAL(IGSE_MainBoxY)
		w = __EVAL(IGSE_MainBoxW)
		h = __EVAL(IGSE_MainBoxH)
		colorBackground[] = {yellow, 1};
	}
	
	class RecentList : igseLISTBOX {
		idc = 1004
		x = __EVAL(IGSE_MainBoxX)
		y = __EVAL(IGSE_MainBoxY)
		w = __EVAL(IGSE_MainBoxW)
		h = __EVAL(IGSE_MainBoxH)
		rowHeight = __EVAL(IGSE_RECENT_ROW_H)
		sizeEx = __EVAL(IGSE_RECENT_ROW_H - 0.005)
		colorText[]   = {windowsgray, 1};	
		colorSelect[] = {black, 1};
	}
	
	class VersionMSG : igseTXT
	{
		idc = 1000
		style = 1 + 256
		x = 0
		y = 0.92
		w = 1
		h = 0.04
		sizeEx = 0.035
		colorBackground[] = {noColor};
		colorText[] = {red, 1};
	};
	
	class Clock : igseTXT
	{
		idc = 1001
		style = 1 + 256
		x = 0
		y = 0.96
		w = 1
		h = 0.04
		sizeEx = 0.035
		colorBackground[] = {noColor};
		colorText[] = {white85, 1};
	};
};