IGSE_SQF_FIND = {
	private ["_i", "_index"];
	_i     = 0;
	_index = -1;
	{
		if (_index == -1) then {
			if ((_this select 0) == _x) then {_index=_i};
			_i = _i + 1;
		}
	} forEach (_this select 1);
	_index
};

IGSE_SQF_UPDATE_BOOKMARKS = {
	private ["_mode", "_line", "_i", "_dir", "_bkmrk"];
	_mode 	= _this select 0;
	_line 	= _this select 1;
	_range	= _this select 2;
	_clip	= _this select 3;
	_added	= _this select 4;
	_dir 	= 1;

	// Shift +1 all bookmarks follwing next line
	if (_mode == "insert") then {
		_mode = "new";
		_line = _line + 1
	};

	// When number of lines change
	if (_mode in ["new", "copy", "delete"]) then {
		// Remove bookmarks from deleted lines
		if (_mode == "delete") then {
			_dir = -1;
			
			// Removing a single line
			if (_range == -1) then {
				_bookmarks = _bookmarks - [_line]
			} else {
				// Removing a range of lines
				_dir = -_range;
				_i   = -1;
				
				while "_i=_i+1;  _i < count _bookmarks" do {
					if ((_bookmarks select _i)>=_line  &&  (_bookmarks select _i)<=(_line+_range)) then {
						_bookmarks = _bookmarks - [(_bookmarks select _i)]
					}
				}
			}
		};

		// Pasting from clipboard
		if (_clip) then {_dir=_added};
		
		// Shift following bookmarks
		_i = -1;
		while "_i=_i+1;  _i < count _bookmarks" do {
			if (_bookmarks select _i > _line) then {
				_bookmarks set [_i, (_bookmarks select _i)+_dir];
			}
		}
	};

	// Update bookmarks when replacing lines
	if (_mode in ["moveup", "movedown"]) then {
		_other  = if (_mode == "movedown") then {_dir=1; _line+1} else {_dir=-1; _line-1};
		_index1 = -1;
		_index2 = -1;
		_i 		= -1;
		
		// Find index of lines that are being shifted
		while "_i=_i+1;  _i < count _bookmarks" do {
			if (_line == (_bookmarks select _i)) then {
				_index1 = _i;
			};
				
			if (_other == (_bookmarks select _i)) then {
				_index2 = _i;
			};
		};

		if (_index1 != -1) then {_bookmarks set [_index1, _line+_dir]};
		if (_index2 != -1) then {_bookmarks set [_index2, _other-_dir]};
	};

	if (count _bookmarks > 1) then {[_bookmarks] call quicksort};
	true
};

IGSE_SQF_SHOW_FILE_ATTRIBUTES = {
	// Show file attributes in the IGSE File Manager dialog
	private ["_string", "_i", "_addComma", "_Day", "_mb", "_kb", "_b", "_size", "_name"];
	false call _ShowPath;

	// Name and extension -----------------------------------------------------------------------------------
	ctrlSetText [12, (_this select 0)];
	ctrlSetText [13, (_this select 1)];

	// File size --------------------------------------------------------------------------------------------
	if ("directory" in (_this select 2)) then {
		ctrlSetText [14, "Folder"]
	} else {
		_mb 	= (_this select 6) select 2;
		_kb 	= (_this select 6) select 1;
		_b 		= (_this select 6) select 0;
		_size 	= _b;
		_name 	= "B";
		
		// Find unit name
		if (_mb > 0) then 
		{
			_name = "MB";
			_size = _kb
		} 
		else
		{
			if (_kb > 0  ||  _kb==0 && _b>=1000) then 
			{
				_name = "KB"; 
				_size = _b
			};
		};

		// Display fraction if larger than 1000 bytes
		if (_name != "B") then
		{
			_size = (_size / 1024);
			_size = _size - (_size mod 0.1);
			
			if (_name == "MB") then {_size = _mb + _size};
			if (_name == "KB") then {_size = _kb + _size};
		};
		
		ctrlSetText [14, Format ["%1 %2", _size,_name]];
	};

	// Add date ---------------------------------------------------------------------------------------------
	_string = "";
	_i 		= [(_this select 5),IGSE_DATE] call FLIB_DATEDIFFDAY;
	
	// File older than a week
	if (_i >= 7) then {
		_string = ["Y-0m-0d 0h:0i", (_this select 5)] call FLIB_FORMATDATE
	} else {
		// This week
		_day = ["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"] select ((_this select 5) select 3);
		
		if (_i == 0) then {_day = "Today"};
		if (_i == 1) then {_day = "Yesterday"};
		
		_string = ["~"+_day+"~ 0h:0i", (_this select 5)] call FLIB_FORMATDATE
	};
	
	ctrlSetText [15, _string];
	
	// Add attributes ---------------------------------------------------------------------------------------
	_i 			= 0;
	_string 	= "";
	_addComma 	= false;
	
	while "_i < count (_this select 2)" do {
		if ((_this select 2) select _i in ["readonly","hidden"]) then {
			if (!_addComma) then {_addComma=true} else {_string=_string+" ,"};	
			if ("readonly"  == (_this select 2) select _i) then {_string=_string+"Read Only"};
			if ("hidden"    == (_this select 2) select _i) then {_string=_string+"Hidden"};
		};
		
		_i = _i + 1;
	};
	
	ctrlSetText [16, _string];

	// Image preview ----------------------------------------------------------------------------------------		
	if ((_this select 1) == "paa" || (_this select 1) == "pac" || (_this select 1) == "jpg"|| (_this select 1) == "jpeg") then {
		(IGSE_PATH_STR+(_this select 0)+"."+(_this select 1)) call IGSE_SQF_IMAGE_PREVIEW;
	};
	
	true
};

IGSE_SQF_ERROR_MESSAGE = {
	private ["_error_array", "_message_prefix","_use_dialog","_code"];

	_error_array = _this select 0;
	_message_prefix = _this select 1;
	_use_dialog = (if (count _this > 2) then {_this select 2} else {false});

	if (!(_error_array select 0)) then {
		_code = Format["#%1",_error_array select 1]; 
		if ((_error_array select 1) in [5,6,7]) then {_code=Format["#%1.%2",_error_array select 1,_error_array select 2]};
		
		if (_use_dialog) then {
			ctrlSetText [6, Format ["%1 %2", _message_prefix, _code]];
			ctrlSetText [7, _error_array select 3];
			{ctrlShow [_x, true]} forEach [6,7];
			_error_msg_time = _time + 10;
		} else {
			player groupChat Format ["%1 %2 %3", _message_prefix, _code, _error_array select 3];
		}
	};

	!(_error_array select 0)
};

IGSE_SQF_LISTBOX_SCROLL = {
	private ["_dir", "_i", "_newPos"];
	_dir = _this;

	// Start a new scroll
	if (_curSel != _lastCurSel) then {
		// Center view
		lbSetCurSel [10, _curSel - IGSE_CENTER]; 
		lbSetCurSel [10, _curSel + IGSE_CENTER]; 
		lbSetCurSel [10, _curSel]; 
		
		// Save
		_lastCurSel = _curSel;
		_ctrlScroll = 0
	};

	// Do scrolling
	_newPos = _curSel + IGSE_CENTER*_dir + (_ctrlScroll+_dir);

	// Don't go out of bounds
	if (_newPos>=0  &&  _newPos<lbSize 10) then {
		_ctrlScroll = _ctrlScroll + _dir;

		// If scrolling past selection
		// then move selection as well
		if (abs _ctrlScroll > IGSE_CENTER) then {
			_curSel = _curSel + _dir;
			_lastCurSel = _curSel;
			_ctrlScroll = IGSE_CENTER * _dir
		};
		
		lbSetCurSel [10, _curSel + IGSE_CENTER*_dir + _ctrlScroll];
		lbSetCurSel [10, _curSel];
	};
};

IGSE_SQF_EXTENSION_TO_IMAGE = {
	private ["_file", "_tokens","_extension","_index","_output","_row"];

	_file      = _this select 0;
	_extension = "";
	_output    = "..\In-Game-Script-Editor\paa\default.paa";
	_row       = if (count _this > 2) then {_this select 2} else {-1};

	if (count _this > 1) then {
		_extension = _this select 1;
	} else {
		_tokens = call loadFile Format ["\:STRING TOKENIZE text:%1delimiter:.", _file];
		if (count _tokens > 0) then {
			_extension = _tokens select (count _tokens-1);
		};
	};

	if (_row >= 0) then {
		lbSetValue [0, _row, 0];
	};

	if (_extension=="htm" || _extension=="url") then {
		_output = "..\In-Game-Script-Editor\paa\html.paa"
	} else {
		if (_extension=="cfg" || _extension=="lip") then {
			_output = "..\In-Game-Script-Editor\paa\ext.paa"
		} else {
			_index = [_extension, IGSE_FILE_ICON_EXT] call IGSE_SQF_FIND;
			if (_index >= 0) then {
				_output = "..\In-Game-Script-Editor\paa\" + _extension + ".paa";
				if (_extension == "pbo" && _row >= 0) then {
					lbSetValue [0, _row, 6]
				}
			} else {
				_index = [_extension, IGSE_FILE_ICON_EXT_BIN] call IGSE_SQF_FIND;
				if (_index >= 0) then {
					if (_row >= 0) then {lbSetValue [0, _row, -1]};
					
					if (_extension=="jpg" || _extension=="jpeg") then {
						_output = "..\In-Game-Script-Editor\paa\jpg.paa";
					} else {
						if (_extension=="paa" || _extension=="pac") then {
							_output = "..\In-Game-Script-Editor\paa\paa.paa";
						} else {
							if (_file=="config.bin" || _file=="resource.bin") then {
								_output = "..\In-Game-Script-Editor\paa\bin.paa";
								if (_row >= 0) then {
									lbSetValue [0, _row, 7];
								}
							} else {
								_output = "..\In-Game-Script-Editor\paa\empty.paa";
							}
						}
					}
				}
			}
		}
	};

	_output
};

IGSE_SQF_REFRESH_FILE_ATTRIBUTES = {
	if (lbPicture [0,IGSE_FM_LASTSEL]==("dtaext\"+_img+"folder_opened.paa")) then {
		lbSetPicture [0, IGSE_FM_LASTSEL, _img+"folder_closed.paa"]
	} else {
		if (lbPicture [0,IGSE_FM_LASTSEL]==("dtaext\"+_img+"shortcut_opened.paa")) then {
			lbSetPicture [0, IGSE_FM_LASTSEL, _img+"shortcut_closed.paa"]
		}
	};

	if (_value == 1) then {
		lbSetPicture [0, _curSel, _img+"folder_opened.paa"]
	} else {
		if (_value in [3,4,5]) then {
			lbSetPicture [0, _curSel, _img+"shortcut_opened.paa"]
		}
	};

	{ctrlSetText [_x, ""]} forEach [61,62,64,68,58,56,52,70,71,72]; // clear image preview

	if (_curSel!=-1 && !(_value in [2,3,4,5]) && _filename!="") then {
		(_filesInfo select (IGSE_LIST_INDEX select (lbCurSel 0))) call IGSE_SQF_SHOW_FILE_ATTRIBUTES
	} else {
		true call _ShowPath
	}
};

IGSE_SQF_IMAGE_PREVIEW = {
	private ["_ok","_error","_type","_width","_height","_ratio","_signature","_alpha","_image_info"];
		
	_ok = call loadFile Format ["\:FILE IMG ""file:%1""", _this];

	if (_ok select 0) then {
		_error     = _ok select 4;
		_type      = _ok select 5;
		_width     = _ok select 6;
		_height    = _ok select 7;
		_ratio     = _ok select 8;
		_signature = _ok select 9;
		_alpha     = _ok select 10;
		
		if (_error != 1 && _error != 2) then {
			ctrlSetText [70, Format ["%1x%2 %3 %4", _width, _height, _signature, (if (_error==3) then {_type} else {""})]];
			
			_image_info = "";
			
			if (abs _ratio > 8) then {
				_image_info = Format ["%1DedServer:NO! ",_image_info];
			};
			
			if (_alpha >= 0) then {
				_image_info = Format ["%1AlphaFlag:%2 ",_image_info, _alpha];
			};
			
			ctrlSetText [72, _image_info]
		};
		
		if (_error in [0,6]) then {
			if (abs _ratio > 8) then {_ratio=if (_ratio > 0) then {8} else {-8}};
			ctrlSetText [60+_ratio, _this];
		} else {
			ctrlSetText [71, 
				[
					"no error",
					"unknown image signature",
					"corrupted file",
					"incorrect file extension",
					"incompatible image format",
					"incorrect resolution",
					"incorrect resolution\nfor dedicated server"
				] select _error
			]
		}
	} else {
		[_ok,"FILE READ"] call IGSE_SQF_ERROR_MESSAGE
	}
};

IGSE_SQF_SHOW_HELP_SCREEN = {
	private ["_help1", "_help2", "_info", "_i"];
	_info = [];
	_i    = -1;
	"ctrlEnable [_x,false]" forEach [0,1];

	if (_this == "FM") then {
		ctrlSetText [2, " File Manager Controls "];
		_info = 
		[
			["Arrow up / down", "Previous / next file"],
			["Page up / down", Format ["Go %1 files up / down",IGSE_FM_ROWS]],
			["Home","Go to the beginning"],
			["End","Go to the end"],
			["",""],
			["Double-click LMB","Open file"],
			["Enter","Open file"],
			["Backspace","Parent directory"],
			["Fourth mouse button","Parent directory / exit"],
			["Fifth mouse button","Previous directory / file"],
			["Middle mouse button","Exit"],
			["",""],
			["Letters and numbers", "Type filter"],
			["Backspace", "Delete filter"],
			[".", "Type filter extension"],
			["",""],
			["F2","Rename file"],
			["F5","Reload file list"],
			["F12","Edit configuration"],
			["",""],
			["Ctrl + N","New file"],
			["Shift + Ctrl + N","New folder"],
			["Ctrl + (SHIFT) + C","Copy file (SHIFT to add next file)"],
			["Ctrl + (SHIFT) + X","Cut file (SHIFT to add next file)"],
			["Ctrl + V","Paste file"],
			["Delete","Trash file"],
			["Ctrl + P","Pack folder to a PBO file"],
			["Shift + Ctrl + P","Pack folder to a PBO file with compression"],
			["",""],
			["Ctrl + (Shift) + Tab", "Switch to recent file"],
			["Right mouse button + scroll", "Switch to recent file"]
		];
	};

	if (_this == "TE") then {
		ctrlSetText [2, " Text Editor Controls "];
		_info = 
		[
			["Arrow up / down", "Previous / next line"],
			["Ctrl + up / down","Scroll up / down"],
			["Page up / down", Format ["Go %1 lines up / down",IGSE_LINES]],
			["Ctrl + Home","Go to the first line"],
			["Ctrl + End","Go to the last line"],
			["F2","Go to next bookmark"],
			["Shift + F2", "Go to previous bookmark"],
			["F3","Go to next search result"],
			["Shift + F3", "Go to previous search result"],
			["F4", "Replace search result"],
			["",""],
			["Enter","Save input to file"],
			["Ctrl + Enter","Save input and create a new line below"],
			["Shift + Ctrl + Enter","Save input and create a new line above"],
			["Ctrl + N","Create a new line below the current"],
			["Shift + Ctrl + N","Create a new line above the current"],
			["Ctrl + Delete","Delete line"],
			["Ctrl + Backspace","Clear line"],
			["Ctrl + Shift + Up / down","Move line up / down"],
			["Ctrl + T","Insert tabulator"],
			["Shift + Ctrl + T","Remove tabulator"],
			["Ctrl + Q","Toggle comment"],
			["",""],
			["Hold Alt + Up / Down","Mark lines"],
			["Hold Alt + A","Mark everything"],
			["Hold Alt + C","Copy lines"],
			["Hold Alt + X","Cut lines"],
			["Hold Alt + V","Paste lines"],
			["",""],
			["Ctrl + F2","Toggle bookmark"],
			["Ctrl + F","Find"],
			["Ctrl + H","Replace"],
			["Ctrl + G","Go to..."],
			["Ctrl + O","Open file manager"],
			["Ctrl + W","Exit IGSE"],
			["F5","Reload file"],
			["F12","Edit configuration"],
			["Middle / Fourth mouse button","Exit file"],
			["Ctrl + (Shift) + Tab", "Switch to recent file"],
			["Right mouse button + scroll", "Switch to recent file"]
		];
	};

	while "_i=_i+1; _i < count _info" do {
		ctrlSetText [0, Format ["%1%2\n", ctrlText 0, (_info select _i) select 0]];
		ctrlSetText [1, Format ["%1%2\n", ctrlText 1, (_info select _i) select 1]];
	};
};

/* 
Quicksort implementation for OFP v1.6 by Faguss (ofp-faguss.com)
Usage: 
	call preProcessFile "quicksort.sqf"
	[<array with numbers>, <any array>, <...>] call quicksort
	[<array with strings>, <any array>, <...>, <optional arguments"] call quicksort	
Input:
	Array
Output:
	Nothing (modifies input array)
Example:
	[[3,2,1], ["C","B","A"]] call quicksort
	[["C","B","A"], [3,2,1], "casesensitive:true natural:true"] call quicksort
	
Input array must contain at least one sub-array that contains either numbers or strings
Optionally you can pass other arrays and they will be sorted in the same way as the first one. 
They may contain any data type but must be the same size as the first array.
When sorting strings then last argument in the input may be a string which contains options for the string comparison:
	- caseSensitive:true - enables case sensitivity
	- reverseCase:true - puts capital letters before lowercase; requires case sensitivity
	- natural:true - sorts by value of the number in the string
*/

// Wrapper function
quicksort = {
	private ["_item", "_options"];
	
	if (count _this > 0) then {
		if (count (_this select 0) > 1) then {
			_item = (_this select 0) select 0;

			// If the first item in the first array is a string then alphabetize
			if (_item in [Format["%1",_item]]) then {
				_options = "";
				
				// Check if input contains options
				if (count _this > 1) then {
					_item = _this select (count _this-1);
					
					if (_item in [_item]) then {
						_options = _item;
						_this resize (count _this-1);
					};
				};
				
				[_this, 0, count (_this select 0)-1, _options] call quicksortABC_loop
			} else {
				[_this, 0, count (_this select 0)-1] call quicksort_loop
			};
		};
	};
};

// Number sorting
quicksort_loop = {
	private ["_input", "_to_sort", "_lo", "_hi", "_i", "_j", "_mid", "_temp"];
	
	_input   = _this select 0;
	_to_sort = _input select 0;
	_lo      = _this select 1;
	_hi      = _this select 2;
	_i       = _lo;
	_j       = _hi;

	// Find pivot
	_mid = (_lo + _hi) / 2;
	_mid = _mid - (_mid mod 1);
	_mid = _to_sort select _mid;

	// Compare
	while {_i <= _j} do {	
		while {(_to_sort select _i) < _mid} do {_i=_i+1};
		while {(_to_sort select _j) > _mid} do {_j=_j-1};
		
		// Replace values in all passed arrays
		if (_i <= _j) then {
			{
				_temp = _x select _i;
				_x set [_i, _x select _j];
				_x set [_j, _temp];
			} forEach _input;
			
			_i = _i + 1;
			_j = _j - 1;
		}
	};

	// Recurrence
	if (_lo < _j) then {[_input, _lo, _j] call quicksort_loop};
	if (_i < _hi) then {[_input, _i, _hi] call quicksort_loop};
};

// String sorting
quicksortABC_loop = {
	private ["_input", "_to_sort", "_lo", "_hi", "_i", "_j", "_options", "_mid", "_temp"];
	
	_input   = _this select 0;
	_to_sort = _input select 0;
	_lo      = _this select 1;
	_hi      = _this select 2;
	_i       = _lo;
	_j       = _hi;
	_options = _this select 3;

	// Find pivot
	_mid = (_lo + _hi) / 2;
	_mid = _mid - (_mid mod 1);
	_mid = _to_sort select _mid;

	// Compare
	while {_i <= _j} do {
		while {
			(call loadFile Format ["\:STRING COMPARE %1 text1:%2text2:%3", _options, (_to_sort select _i), _mid]) == -1
		} do {
			_i = _i + 1;
		};
		
		while {
			(call loadFile Format ["\:STRING COMPARE %1 text1:%2text2:%3", _options, (_to_sort select _j), _mid]) ==  1
		} do {
			_j = _j - 1;
		};
					
		// Replace values in all passed arrays
		if (_i <= _j) then {
			{
				_temp = _x select _i;
				_x set [_i, _x select _j];
				_x set [_j, _temp];
			} forEach _input;
			
			_i = _i + 1;
			_j = _j - 1;
		}
	};

	// Recurrence
	if (_lo < _j) then {[_input, _lo, _j, _options] call quicksortABC_loop};
	if (_i < _hi) then {[_input, _i, _hi, _options] call quicksortABC_loop};	
};