MATH_PLACE2D = {
	private ["_pos", "_sin_dir", "_cos_dir", "_side", "_forward"];

	_pos     = +(_this select 0);
	_sin_dir = sin (_this select 1);
	_cos_dir = cos (_this select 1);
	_side    = 0;
	_forward = _this select 2;
	
	if (count _this > 3) then {
		_side    = _this select 2; 
		_forward = _this select 3
	};

	_pos set [0, (_pos select 0) + _forward * _sin_dir + _side * _cos_dir];
	_pos set [1, (_pos select 1) + _forward * _cos_dir - _side * _sin_dir];
	_pos
};

MATH_PLACE3D = {
	private ["_pos", "_yaw", "_bank", "_pitch", "_side", "_forward", "_up", "_pos_z", "_sinyaw", "_cosyaw", "_sinbank", "_cosbank", "_sinpitch", "_cospitch", "_Z", "_X", "_XY", "_Y"];

	_pos     = _this select 0;
	_yaw	 = _this select 1;
	_bank 	 = _this select 2;
	_pitch   = _this select 3;
	_side	 = _this select 4;
	_forward = _this select 5;
	_up		 = _this select 6;

	_pos_z    = if (count _pos > 2) then {_pos select 2} else {0};
	_sinyaw   = sin -_yaw;
	_cosyaw   = cos -_yaw;
	_sinbank  = sin _bank;
	_cosbank  = cos _bank;
	_sinpitch = sin _pitch;
	_cospitch = cos _pitch;

    _Z  = _cosbank * _up - _sinbank * _side;
    _X  = _sinbank * _up + _cosbank * _side;

    _XY = _cospitch * _forward - _sinpitch * _Z;
    _Z  = _sinpitch * _forward + _cospitch * _Z;

    _Y  = _sinyaw * _X + _cosyaw * _XY;
    _X  = _cosyaw * _X - _sinyaw * _XY;

	[
		(_pos select 0) + _X,
		(_pos select 1) + _Y,
		_pos_z          + _Z
	]
};

MATH_DIST2D = {
	private ["_source", "_target"];

	_source = _this select 0;
	_target = _this select 1;

	sqrt 
	(
		((_target select 0) - (_source select 0))^2 
		+ 
		((_target select 1) - (_source select 1))^2
	)
};

MATH_DIST3D = {
	private ["_source", "_target"];

	_source = _this select 0;
	_target = _this select 1;

	sqrt 
	(
		((_target select 0) - (_source select 0))^2 
		+ 
		((_target select 1) - (_source select 1))^2
		+ 
		((_target select 2) - (_source select 2))^2
	)
};

MATH_POS2DIR = {
	private ["_source", "_target", "_diffX", "_diffY", "_dir"];

	_source = _this select 0;
	_target = _this select 1;

	_diffX  = (_target select 0) - (_source select 0);
	_diffY  = (_target select 1) - (_source select 1);
	_dir    = if (_diffX==0 && _diffY==0) then {0} else {_diffX atan2 _diffY};
	if (_dir < 0) then {_dir=_dir+360};  

	_dir
};

MATH_POS2PITCH = {
	private ["_source", "_target", "_height", "_distance"];

	_source = _this select 0;
	_target = _this select 1;

	_height   = (_target select 2) - (_source select 2);
	_distance = sqrt (((_target select 0) - (_source select 0))^2 + ((_target select 1) - (_source select 1))^2 + ((_target select 2) - (_source select 2))^2);
	
	if (_distance == 0) then {
		0
	} else {
		asin (_height / _distance)
	}
};

MATH_ABS2REL = {
	private ["_source_x", "_source_y", "_source_z", "_source_dir", "_target_x", "_target_y", "_target_z", "_diffX", "_diffY", "_dir", "_distance"];

	_source_x   = (_this select 0) select 0;
	_source_y   = (_this select 0) select 1;
	_source_z   = if (count (_this select 0) > 2) then {(_this select 0) select 2} else {0};
	_source_dir = _this select 1;
	_target_x   = (_this select 2) select 0;
	_target_y   = (_this select 2) select 1;
	_target_z   = if (count (_this select 2) > 2) then {(_this select 0) select 2} else {0};

	_diffX     = _target_x - _source_x;
	_diffY     = _target_y - _source_y;
	_dir       = if (_diffX==0 && _diffY==0) then {0} else {_diffX atan2 _diffY};
	if (_dir < 0) then {_dir=_dir+360};

	_dir       = _dir - _source_dir;
	_distance  = sqrt ((_target_x-_source_x)^2 + (_target_y-_source_y)^2);

	[
		_distance * sin _dir,
		_distance * cos _dir,
		_target_z - _source_z
	]
};

MATH_REL2ABS = {
	private ["_source_pos", "_dir", "_relative_pos", "_source_z", "_relative_z", "_sin", "_cos"];

	_source_pos   = _this select 0;
	_dir          = _this select 1;
	_relative_pos = _this select 2;

	_source_z     = if (count _source_pos > 2) then {_source_pos select 2} else {0};
	_relative_z   = if (count _source_pos > 2) then {_source_pos select 2} else {0};
	_sin          = sin _dir;
	_cos          = cos _dir;

	[
		(_source_pos select 0) + (_relative_pos select 1)*_sin + (_relative_pos select 0)*_cos,
		(_source_pos select 1) + (_relative_pos select 1)*_cos - (_relative_pos select 0)*_sin,
		_source_z + _relative_z
	]
};

MATH_POLYGONS_INTERSECT = {
	private ["_i", "_terminate", "_polygon", "_i1", "_i2", "_p1", "_p2", "_normal", "_minA", "_maxA", "_j", "_projected", "_minB", "_maxB"];

	_i         = -1; 
	_terminate = false;
	
	while "_i=_i+1; _i < count _this && !_terminate" do {
		_polygon = _this select _i; 
		_i1      = -1; 
		
		while "_i1=_i1+1; _i1 < count _polygon && !_terminate" do {
			_i2     = (_i1 + 1) % count _polygon;
			_p1     = _polygon select _i1;
			_p2     = _polygon select _i2;
			_normal = [(_p2 select 1) - (_p1 select 1), (_p1 select 0) - (_p2 select 0)];
			_minA   = nil; 
			_maxA   = nil; 
			_j      = -1; 
			
			while "_j=_j+1; _j < count (_this select 0)" do {
				_projected = (_normal select 0) * (((_this select 0) select _j) select 0) + (_normal select 1) * (((_this select 0) select _j) select 1);
				
				if (Format ["%1",_minA] == "scalar bool array string 0xfcffffef") then {
					_minA = _projected
				} else {
					if (_projected < _minA) then {_minA = _projected}
				};
				
				if (Format ["%1",_maxA] == "scalar bool array string 0xfcffffef") then {
					_maxA = _projected
				} else {
					if (_projected > _maxA) then {_maxA = _projected}
				}
			};
				
			_j      = -1; 
			_minB   = nil; 
			_maxB   = nil; 
			
			while "_j=_j+1; _j < count (_this select 1)" do {
				_projected = (_normal select 0) * (((_this select 1) select _j) select 0) + (_normal select 1) * (((_this select 1) select _j) select 1);
				
				if (Format ["%1",_minB] == "scalar bool array string 0xfcffffef") then {
					_minB = _projected
				} else {
					if (_projected < _minB) then {_minB = _projected}
				};
				
				if (Format ["%1",_maxB] == "scalar bool array string 0xfcffffef") then {
					_maxB = _projected
				} else {
					if (_projected > _maxB) then {_maxB = _projected}
				}
			};

			if (_maxA < _minB || _maxB < _minA) then {_terminate=true}
		}
	};
		
	if (_terminate) then {false} else {true}
};

MATH_CORNERS_RECTANGLE = {
	private ["_pos", "_sin_dir", "_cos_dir", "_width", "_height", "_pos_z", "_height_sin_dir", "_height_cos_dir", "_width_sin_dir", "_width_cos_dir"];

	_pos     = _this select 0;
	_sin_dir = sin (_this select 1);
	_cos_dir = cos (_this select 1);
	_width   = _this select 2;
	_height  = _this select 3;

	_pos_z          = if (count _pos > 2) then {_pos select 2} else {0};
	_height_sin_dir = _height * _sin_dir;
	_height_cos_dir = _height * _cos_dir;
	_width_sin_dir  = _width  * _sin_dir;
	_width_cos_dir  = _width  * _cos_dir;

	[
		[(_pos select 0) + _height_sin_dir - _width_cos_dir, (_pos select 1) + _height_cos_dir + _width_sin_dir, _pos_z],
		[(_pos select 0) + _height_sin_dir + _width_cos_dir, (_pos select 1) + _height_cos_dir - _width_sin_dir, _pos_z],
		[(_pos select 0) - _height_sin_dir + _width_cos_dir, (_pos select 1) - _height_cos_dir - _width_sin_dir, _pos_z],
		[(_pos select 0) - _height_sin_dir - _width_cos_dir, (_pos select 1) - _height_cos_dir + _width_sin_dir, _pos_z]
	]
};

MATH_RADIUS_RECTANGLE = {
	private ["_rotation", "_width", "_height", "_beta", "_phi"];

	_rotation = _this select 0;
	_width    = _this select 2;
	_height   = _this select 1;

	if (_width!=0 && _height!=0) then {
		_beta = atan (abs (tan _rotation));
		_phi  = atan (_height / _width);

		if (_beta >= _phi) then {
			(_height / (2 * sin _beta)) * 2
		} else {
			(_width / (2 * cos _beta)) * 2
		}
	} else {
		0
	}
};

MATH_INSIDE_RECTANGLE = {
	private ["_source", "_rotation", "_width", "_height", "_target", "_diffX", "_diffY", "_dir", "_distance", "_radius", "_beta", "_phi"];

	_source   = _this select 0;
	_rotation = _this select 1;
	_width    = _this select 3;
	_height   = _this select 2;
	_target   = _this select 4;

	_diffX  = (_target select 0) - (_source select 0);
	_diffY  = (_target select 1) - (_source select 1);
	_dir    = if (_diffX==0 && _diffY==0) then {0} else {_diffX atan2 _diffY};
	if (_dir < 0) then {_dir=_dir+360};

	_distance = sqrt (_diffX^2 + _diffY^2);
	_radius   = if (_width!=0 && _height!=0) then {
		_beta = atan (abs (tan (_rotation-_dir)));
		_phi  = atan (_height / _width);

		if (_beta >= _phi) then {
			(_height / (2 * sin _beta)) * 2
		} else {
			(_width / (2 * cos _beta)) * 2
		}
	} else {
		0
	};

	_distance < _radius
};

MATH_RADIUS_ELLIPSE = {
	private ["_rotation", "_width", "_height"];

	_rotation = _this select 0;
	_width    = _this select 1;
	_height   = _this select 2;

	if (_width!=0 && _height!=0) then {
		(_width * _height) / sqrt(_height^2 * (sin _rotation)^2 + _width^2 * (cos _rotation)^2)
	} else {
		0
	}
};

MATH_INSIDE_ELLIPSE = {
	private ["_source", "_rotation", "_width", "_height", "_target", "_diffX", "_diffY", "_dir", "_distance", "_radius"];

	_source   = _this select 0;
	_rotation = _this select 1;
	_width    = _this select 2;
	_height   = _this select 3;
	_target   = _this select 4;

	_diffX  = (_target select 0) - (_source select 0);
	_diffY  = (_target select 1) - (_source select 1);
	_dir    = if (_diffX==0 && _diffY==0) then {0} else {_diffX atan2 _diffY};
	if (_dir < 0) then {_dir=_dir+360};

	_distance = sqrt (_diffX^2 + _diffY^2);
	_rotation = _rotation - _dir;
	_radius   = if (_width!=0 && _height!=0) then {
		(_width * _height) / sqrt(_height^2 * (sin _rotation)^2 + _width^2 * (cos _rotation)^2)
	} else {
		0
	};

	_distance < _radius
};

MATH_VEL2INFO = {
	private ["_v", "_xy", "_z", "_speed", "_dir", "_pitch"];

	_v     = velocity _this;
	_xy    = sqrt((_v select 0)^2 + (_v select 1)^2);
	_z     = _v select 2;
	_speed = 0;
	_dir   = 0;
	_pitch = 0;

	if (_xy == 0) then {
		if (_z == 0) then {
			_pitch = 0;
		} else {
			_pitch = if (_z > 0) then {90} else {-90};
		};
		_speed = abs _z;
		_dir   = getDir _this;
	} else {
		_speed = _xy / cos (atan (_z / _xy));
		_dir   = (_v select 0) atan2 (_v select 1);
		_pitch = atan (_z / _xy);
		if (_dir < 0) then {_dir=_dir+360};
	};

	[_speed*3.6, _dir, _pitch]
};

MATH_ROUND = {
	private ["_number", "_roundto", "_remainder"];

	_number  = _this;
	_roundto = 1;

	if (!(_this in [_this])) then {
		_number = _this select 0;
		if (count _this > 1) then {_roundto=_this select 1};
	};
	
	if (_roundto == 0) then {
		0
	} else {
		_remainder = _number mod _roundto;
		_number - _remainder + (if (_remainder >= (_roundto/2)) then {_roundto} else {0})
	}
};
